CREATE TABLE [dbo].[sales](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[custId] [int] NULL,
	[Name] [nvarchar](50) NULL,
	[organisation] [nvarchar](50) NULL,
	[street] [nvarchar](50) NULL,
	[district] [nvarchar](50) NULL,
	[town] [nvarchar](50) NULL,
	[county] [nvarchar](50) NULL,
	[postcode] [nvarchar](50) NULL,
	[newcust] [bit] NOT NULL,
	[itemsCount] [int] NOT NULL,
	[ItemsCost] [decimal](18, 2) NOT NULL,
	[tax1] [decimal](18, 2) NOT NULL,
	[tax2] [decimal](18, 2) NOT NULL,
	[total] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_sales] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_newcust]  DEFAULT ((0)) FOR [newcust]
~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_itemsCount]  DEFAULT ((0)) FOR [itemsCount]
~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_totalCost]  DEFAULT ((0)) FOR [ItemsCost]
~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_tax1]  DEFAULT ((0)) FOR [tax1]
~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_tax2]  DEFAULT ((0)) FOR [tax2]
~

ALTER TABLE [dbo].[sales] ADD  CONSTRAINT [DF_sales_total]  DEFAULT ((0)) FOR [total]
~


CREATE TABLE [dbo].[salesItems](
	[salesId] [int] NOT NULL,
	[ItemSeq] [int] NOT NULL,
	[partId] [int] NOT NULL,
	[partCode] [nvarchar](50) NULL,
	[Quant] [int] NOT NULL,
	[discountperc] [decimal](18, 0) NOT NULL,
	[cost] [decimal](18, 2) NOT NULL,
	[total] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_salesItems_1] PRIMARY KEY CLUSTERED 
(
	[salesId] ASC,
	[ItemSeq] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

~

ALTER TABLE [dbo].[salesItems] ADD  CONSTRAINT [DF_salesItems_Quant]  DEFAULT ((1)) FOR [Quant]
~

ALTER TABLE [dbo].[salesItems] ADD  CONSTRAINT [DF_salesItems_discountperc]  DEFAULT ((0)) FOR [discountperc]
~

ALTER TABLE [dbo].[salesItems] ADD  CONSTRAINT [DF_salesItems_cost]  DEFAULT ((0)) FOR [cost]
~

ALTER TABLE [dbo].[salesItems] ADD  CONSTRAINT [DF_salesItems_total]  DEFAULT ((0)) FOR [total]
~


CREATE TABLE [dbo].[salesItemsMisc](
	[salesId] [int] NOT NULL,
	[ItemSeq] [int] NOT NULL,
	[partName] [nvarchar](50) NOT NULL,
	[notes] [nvarchar](500) NULL,
	[partCode] [nvarchar](50) NULL,
	[Quant] [int] NOT NULL,
	[discountperc] [decimal](18, 0) NOT NULL,
	[cost] [decimal](18, 2) NOT NULL,
	[total] [decimal](18, 2) NOT NULL,
 CONSTRAINT [PK_salesItemsMisc_1] PRIMARY KEY CLUSTERED 
(
	[salesId] ASC,
	[ItemSeq] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

~

ALTER TABLE [dbo].[salesItemsMisc] ADD  CONSTRAINT [DF_salesItemsMisc_Quant]  DEFAULT ((1)) FOR [Quant]
~

ALTER TABLE [dbo].[salesItemsMisc] ADD  CONSTRAINT [DF_salesItemsMisc_discountperc]  DEFAULT ((0)) FOR [discountperc]
~

ALTER TABLE [dbo].[salesItemsMisc] ADD  CONSTRAINT [DF_salesItemsMisc_cost]  DEFAULT ((0)) FOR [cost]
~

ALTER TABLE [dbo].[salesItemsMisc] ADD  CONSTRAINT [DF_salesItemsMisc_total]  DEFAULT ((0)) FOR [total]
~


CREATE PROCEDURE [dbo].[tr_getPartsByCategory]
	@category int

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

SELECT DISTINCT dbo.PartImages.PartId, dbo.Images.filepath, dbo.Images.Note, dbo.Images.id, 
	dbo.partsstore.category,partsstore.cost,partsstore.description,partsstore.partname,partsstore.quant 
	FROM dbo.partsstore INNER JOIN
	dbo.PartImages ON dbo.partsstore.id = dbo.PartImages.PartId LEFT OUTER JOIN
	dbo.Images ON dbo.PartImages.ImageId = dbo.Images.id
	where partsstore.category = @category
                      
END

~


CREATE PROCEDURE [dbo].[tr_salesItems]
	@SalesID int

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

SELECT [salesId], [ItemSeq], [partId], [partCode], partname, b.description,
a.Quant, [discountperc], [total], a.cost 
FROM salesItems a
inner join partsstore b on a.partId=b.id
WHERE [salesId] = @SalesID
                      
END

~

INSERT INTO [menus] ([id],[title],[url],[seclevel],[order],parent)VALUES(47,'Sales','~/Sales.aspx','4','8','0')

INSERT INTO [menus] ([id],[title],[url],[seclevel],[order],parent)VALUES(48,'Sales','~/Sales.aspx','5','24','38')


